/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.integrator;

import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.api.VWSystemConfiguration;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.property.base.VWConfigExposedFieldPanel;
import filenet.vw.toolkit.admin.property.base.VWConfigFilteredSecurityPanel;
import filenet.vw.toolkit.admin.property.base.VWConfigGeneralPane;
import filenet.vw.toolkit.admin.property.base.VWConfigIndexPane;
import filenet.vw.toolkit.admin.property.base.VWConfigSecurityPane;
import filenet.vw.toolkit.admin.property.base.VWConfigSystemFieldPanel;
import filenet.vw.toolkit.admin.property.integrator.VWAdaptorInfo;
import filenet.vw.toolkit.admin.property.integrator.VWConfigurationPanel;
import filenet.vw.toolkit.admin.property.integrator.VWImportOperationPanel;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VWComponentPropertyDialog
extends VWModalDialog
implements ActionListener,
ChangeListener {
    private JTabbedPane m_tabbedPanel = new JTabbedPane();
    private VWConfigGeneralPane m_generalPanel = null;
    private VWConfigSystemFieldPanel m_sysExposedFieldsPanel = null;
    private VWConfigExposedFieldPanel m_userExposedFieldsPanel = null;
    private VWConfigIndexPane m_indexTablePanel = null;
    private VWConfigSecurityPane m_securityPanel = null;
    private VWConfigurationPanel m_configurationPanel = null;
    private VWImportOperationPanel m_importOperationPanel = null;
    private JButton m_OKButton = null;
    private JButton m_cancelButton = null;
    private JButton m_helpButton = null;
    private Frame m_parentFrame = null;
    private VWAdaptorInfo m_adaptorInfo = null;
    private int m_nRetStatus = 1;
    private VWParticipant[] m_readSecurity = null;
    private VWParticipant[] m_writeSecurity = null;

    public VWComponentPropertyDialog(Frame parentFrame, VWSessionInfo sessionInfo, VWQueueDefinition queueDef, VWSystemConfiguration vwSysConfig, int itemsInQueue) {
        super(parentFrame);
        try {
            this.m_parentFrame = parentFrame;
            this.m_adaptorInfo = new VWAdaptorInfo(queueDef);
            this.setTitle(VWResource.ComponentProperties);
            VWAccessibilityHelper.setAccessibility(this, null, VWResource.ComponentProperties, VWResource.ComponentProperties);
            this.getContentPane().setLayout(new BorderLayout());
            Dimension dim = VWStringUtils.stringToDimension("715,495");
            if (dim == null) {
                dim = new Dimension(650, 450);
            }
            this.setSize(dim.width, dim.height);
            this.setVisible(false);
            Font aFont = this.getFont();
            Font boldFont = new Font(aFont.getName(), 1, aFont.getSize());
            this.m_tabbedPanel.setFont(boldFont);
            String queueType = null;
            switch (queueDef.getQueueType()) {
                case 1: {
                    if (queueDef.getIsConnectorQueue()) {
                        queueType = VWResource.Component;
                        break;
                    }
                    queueType = VWResource.Work;
                    break;
                }
                case 2: {
                    queueType = VWResource.UserCentric;
                }
            }
            this.m_generalPanel = new VWConfigGeneralPane(queueDef.getName(), VWResource.Queue, queueType, queueDef.getServerId(), queueDef.getDescription());
            this.m_tabbedPanel.add(VWResource.General, this.m_generalPanel);
            VWAccessibilityHelper.setAccessibility(this.m_generalPanel, this, VWResource.General, VWResource.General);
            this.m_sysExposedFieldsPanel = new VWConfigSystemFieldPanel(this.m_parentFrame, sessionInfo.getSession(), queueDef);
            this.m_tabbedPanel.add(VWResource.SystemFields, this.m_sysExposedFieldsPanel);
            VWAccessibilityHelper.setAccessibility(this.m_sysExposedFieldsPanel, this, VWResource.SystemFields, VWResource.SystemFields);
            this.m_userExposedFieldsPanel = new VWConfigExposedFieldPanel(this.m_parentFrame, vwSysConfig, sessionInfo.getSession().getDatabaseType(), queueDef, itemsInQueue);
            this.m_tabbedPanel.add(VWResource.DataFields, this.m_userExposedFieldsPanel);
            VWAccessibilityHelper.setAccessibility(this.m_userExposedFieldsPanel, this, VWResource.DataFields, VWResource.DataFields);
            this.m_indexTablePanel = new VWConfigIndexPane(this.m_parentFrame, queueDef);
            this.m_tabbedPanel.add(VWResource.Indexes, this.m_indexTablePanel);
            VWAccessibilityHelper.setAccessibility(this.m_indexTablePanel, this, VWResource.Indexes, VWResource.Indexes);
            this.m_readSecurity = queueDef.getReadSecurityPx();
            this.m_writeSecurity = queueDef.getWriteSecurityPx();
            this.m_securityPanel = sessionInfo.getSession().getSecurityDatabaseType() == 1 ? new VWConfigFilteredSecurityPanel(this, sessionInfo, this.m_readSecurity, this.m_writeSecurity, 1) : new VWConfigSecurityPane(this, sessionInfo, this.m_readSecurity, this.m_writeSecurity, 1);
            this.m_tabbedPanel.add(VWResource.Security, this.m_securityPanel);
            VWAccessibilityHelper.setAccessibility(this.m_securityPanel, this, VWResource.Security, VWResource.Security);
            this.m_configurationPanel = new VWConfigurationPanel(this, this.m_adaptorInfo, sessionInfo, vwSysConfig);
            this.m_tabbedPanel.add(VWResource.Adaptor, this.m_configurationPanel);
            VWAccessibilityHelper.setAccessibility(this.m_configurationPanel, this, VWResource.Adaptor, VWResource.Adaptor);
            this.m_importOperationPanel = new VWImportOperationPanel(this.m_parentFrame, this.m_adaptorInfo, vwSysConfig);
            this.m_tabbedPanel.add(VWResource.Operations, this.m_importOperationPanel);
            VWAccessibilityHelper.setAccessibility(this.m_importOperationPanel, this, VWResource.Operations, VWResource.Operations);
            this.m_tabbedPanel.setSelectedIndex(0);
            this.m_tabbedPanel.addChangeListener(this);
            this.getContentPane().add((Component)this.m_tabbedPanel, "Center");
            this.getContentPane().add((Component)this.createButtonPanel(), "Last");
            VWAccessibilityHelper.setAccessibility(this.m_tabbedPanel, this, VWResource.s_componentProperties, VWResource.s_componentProperties);
            this.setLocationRelativeTo(parentFrame);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void addNotify() {
        super.addNotify();
        this.m_tabbedPanel.requestFocus();
    }

    public int getStatus() {
        return this.m_nRetStatus;
    }

    public boolean isModified() {
        return this.m_generalPanel.isModified() || this.m_sysExposedFieldsPanel.isModified() || this.m_userExposedFieldsPanel.isModified() || this.m_indexTablePanel.isModified() || this.m_securityPanel.isModified() || this.m_configurationPanel.isModified() || this.m_importOperationPanel.isModified();
    }

    public void releaseResources() {
        if (this.m_tabbedPanel != null) {
            this.m_tabbedPanel.removeAll();
            this.m_tabbedPanel = null;
        }
        if (this.m_generalPanel != null) {
            this.m_generalPanel.releaseResources();
            this.m_generalPanel = null;
        }
        if (this.m_sysExposedFieldsPanel != null) {
            this.m_sysExposedFieldsPanel.releaseResources();
            this.m_sysExposedFieldsPanel = null;
        }
        if (this.m_userExposedFieldsPanel != null) {
            this.m_userExposedFieldsPanel.releaseResources();
            this.m_userExposedFieldsPanel = null;
        }
        if (this.m_indexTablePanel != null) {
            this.m_indexTablePanel.releaseResources();
            this.m_indexTablePanel = null;
        }
        if (this.m_securityPanel != null) {
            this.m_securityPanel.releaseResources();
            this.m_securityPanel = null;
        }
        if (this.m_configurationPanel != null) {
            this.m_configurationPanel.releaseResources();
            this.m_configurationPanel = null;
        }
        if (this.m_importOperationPanel != null) {
            this.m_importOperationPanel.releaseResources();
            this.m_importOperationPanel = null;
        }
        if (this.m_OKButton != null) {
            this.m_OKButton.removeActionListener(this);
            this.m_OKButton.removeAll();
            this.m_OKButton = null;
        }
        if (this.m_cancelButton != null) {
            this.m_cancelButton.removeActionListener(this);
            this.m_cancelButton.removeAll();
            this.m_cancelButton = null;
        }
        if (this.m_helpButton != null) {
            this.m_helpButton.removeActionListener(this);
            this.m_helpButton.removeAll();
            this.m_helpButton = null;
        }
        this.m_parentFrame = null;
        if (this.m_adaptorInfo != null) {
            this.m_adaptorInfo.releaseResources();
            this.m_adaptorInfo = null;
        }
        if (this.m_readSecurity != null) {
            this.m_readSecurity = null;
        }
        if (this.m_writeSecurity != null) {
            this.m_writeSecurity = null;
        }
        this.removeAll();
    }

    public void actionPerformed(ActionEvent event) {
        Object obj = event.getSource();
        if (obj.equals(this.m_cancelButton)) {
            this.m_nRetStatus = 1;
            this.setVisible(false);
        } else if (obj.equals(this.m_OKButton)) {
            try {
                this.stopEditing();
                if (this.m_adaptorInfo != null) {
                    VWQueueDefinition queueDef = this.m_adaptorInfo.getQueueDefinition();
                    if (!this.m_securityPanel.ValidateAccessList()) {
                        return;
                    }
                    queueDef.setReadSecurityPx(this.m_securityPanel.getReadSecurityPx());
                    queueDef.setWriteSecurityPx(this.m_securityPanel.getWriteSecurityPx());
                    this.m_configurationPanel.checkForErrors();
                    queueDef.setDescription(this.m_generalPanel.getDescription());
                    if (this.m_adaptorInfo != null) {
                        this.m_adaptorInfo.setDescription(this.m_generalPanel.getDescription());
                        this.m_adaptorInfo.save();
                    }
                }
                this.m_nRetStatus = 0;
                this.setVisible(false);
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                String msg = ex.getLocalizedMessage();
                if (msg == null || msg.length() == 0) {
                    msg = VWResource.ErrorSavingQueueProperties;
                }
                JOptionPane.showMessageDialog(this.m_parentFrame, msg, VWResource.ErrorMessage, 0);
            }
        } else if (obj.equals(this.m_helpButton)) {
            VWHelp.displayPage(VWHelp.Help_Process_Config + "bpfc051.htm");
        }
    }

    public void stateChanged(ChangeEvent event) {
        Component aComponent;
        Object sourceObject = event.getSource();
        if (sourceObject == this.m_tabbedPanel && ((aComponent = this.m_tabbedPanel.getSelectedComponent()) == this.m_indexTablePanel || aComponent == this.m_securityPanel)) {
            this.stopEditing();
        }
    }

    private JPanel createButtonPanel() {
        try {
            JPanel buttonPanel = new JPanel(new FlowLayout(1, 6, 6));
            this.m_OKButton = new JButton(VWResource.OK);
            this.m_OKButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_OKButton, buttonPanel, VWResource.OK, VWResource.OK);
            this.m_OKButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            buttonPanel.add(this.m_OKButton);
            this.m_cancelButton = new JButton(VWResource.Cancel);
            this.m_cancelButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_cancelButton, buttonPanel, VWResource.Cancel, VWResource.Cancel);
            this.m_cancelButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            buttonPanel.add(this.m_cancelButton);
            this.m_helpButton = new JButton(VWResource.Help);
            this.m_helpButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_helpButton, buttonPanel, VWResource.Help, VWResource.Help);
            this.m_helpButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            buttonPanel.add(this.m_helpButton);
            return buttonPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void stopEditing() {
        this.m_sysExposedFieldsPanel.stopEditing();
        this.m_userExposedFieldsPanel.stopEditing();
        this.m_importOperationPanel.stopEditing();
    }
}

